<?Lassoscript
// Last modified: 1/15/07 by ECL, Landmann InterActive
// Prepared for Lasso Summit 07
//
// siteconfig.lasso - set up system variables, databases, tables, etc.
// ------------------------------------------------------------------------
// LBT is a commercial application
// Copyright ©2007 Landmann Assoc., Inc., Madison, WI USA

// DEVELOPER'S NOTE
// When changing this file, **remember to look in the siteconfig.lasso file as well***

// Site username and password
Var:'svSiteUsername'='YourUsername';
Var:'svSitePassword'='YourPassword';

// Databases
// Database and Tables
Var:'svSiteDatabase'='bug_tracker';
Var:'svAttachmentsTable' = 'lbt_attachments';
Var:'svBrowsersTable'='lbt_browsers';
Var:'svBugsTable' = 'lbt_bug';
Var:'svCommentsTable' = 'lbt_comment';
Var:'svErrorsTable'='lbt_errors';
Var:'svGroupsTable' = 'lbt_groups';
Var:'svOSTable' = 'lbt_OS';
Var:'svPriorityTable' = 'lbt_priority';
Var:'svProjectsTable' = 'lbt_project';
Var:'svGroups2ProjectsTable' = 'lbt_groups2projects';
Var:'svQuestionsTable'='lbt_questions';
Var:'svResolutionsTable' = 'lbt_resolution';
Var:'svSavedQueriesTable' = 'lbt_savedquery';
Var:'svBrowserTable' = 'lbt_severity';
Var:'svStatesTable'='lbt_states';
Var:'svStatusTable' = 'lbt_status';
Var:'svSysTable'='lbt_sys';
Var:'svUsers2GroupsTable' = 'lbt_users2groups';
Var:'svUserPrivsTable' = 'lbt_userprivs';
Var:'svUsersTable' = 'lbt_users';
Var:'svUserTypesTable'='lbt_usertypes';
Var:'svVersionsTable' = 'lbt_version';

//	Show Error CT
//  Version 2.0
//  1/6/2005 by ECL, Landmann InterActive
//  NEW VERSION that includes all HTML code and a parameter to accept a background color
//  Usage: Show_Error: -ErrNum=(Var:'vError'), -Option=(Var:'vOption'), -PosColor='00CC00', -NegColor='FF0000', -BgColor='F0F1F1';
		
If: !(Lasso_TagExists:'Show_Error');
	Define_Tag: 'Show_Error',
		-Required = 'ErrNum',
		-Required = 'PosColor',
		-Required = 'NegColor',
		-Required = 'BgColor',
		-Optional = 'Option';

		Local:'Result' = string;

		If: #ErrNum != '';
			Inline: -Database=$svSiteDatabase,-Table=$svErrorsTable,-UserName=$svSiteUsername,-Password=$svSitePassword,
				-SQL="SELECT Code, Message, Title, Attrib
					FROM " $svSiteDatabase "." $svErrorsTable "
					WHERE Code= '" (#ErrNum) "';";
						var:'vErr' = (Error_CurrentError) ' -- ' (Error_CurrentError: -ErrorCode);
						var:'vErrNo' = (Error_CurrentError: -ErrorCode);
	
					If: $vErrNo == 0;
						If: (Found_Count)== 0;
							#Result += 'No Error Message Found';
						Else;

							// Get Attribute from database and assign coloor
							If: (Field:'Attrib') == 'Pos';
								Local:'HeaderColor' = (#PosColor);
							Else;
								Local:'HeaderColor' = (#NegColor);
							/If;

							// Output top of table
							#Result =
								'<table width="80%" border="0" cellspacing="1" cellpadding="2">\r'
								'\t<tr>\r'
								'\t\t<td bgcolor="#' (#HeaderColor)'"><b><font color="#FFFFFF">';
							
							If: #Option != '';
								#Result += ((Field:'Title')'</font></b><br>\r\t\t</td>\r\t</tr>\r\t<tr>\r\t\t<td bgcolor="#'(#BgColor)'">'(String_Replace: (Field:'Message'), -Find='<form_input>', -Replace=#Option));
							Else;
								#Result += ((Field:'Title')'</font></b><br>\r\t\t</td>\r\t</tr>\r\t<tr>\r\t\t<td bgcolor="#'(#BgColor)'"><font color="#000000">'(Field:'Message'));
							/If;
						/If;
					Else;
						#Result += $vErr;
					/If;
			/inline;
		Else;
			// Output top of table
			#Result =
				'<table width="80%" border="0" cellspacing="1" cellpadding="2">\r'
				'\t<tr>\r'
				'\t\t<td bgcolor="#'(#HeaderColor)'"><b><font color="'(#BgColor)'">';
					#Result += 'EXCEPTION: An Unknown Error Was Generated';
		/If;

	// Output bottom of table
	#Result +=
		'</font></td>\r'
		'\t</tr>\r'
		'</table>\r'
		'&nbsp;<br>\r';

			Return: Encode_Smart:(#Result);

	 /Define_Tag; 

/If;


// Tagname: 	GetUserName
// Description:	Gets the User Name when passed a User_ID
// Author:		Eric Landmann
// Date:		8/7/2006
// Usage: 		GetUserName: -ID='2F0a33X'
// Notes: 		Expected output from tag: "Eric Landmann"
If: !(Lasso_TagExists:'GetUserName');

	Define_Tag: 'GetUserName', -Required='ID';
	
		Local:'Result' = string;
		Local:'SQLGetUserName' = string;
		Local:'vUserNameLabel' = string;
		
		#SQLGetUserName = 'SELECT User_ID,User_FName,User_LName FROM ' $svUsersTable ' WHERE User_ID = "' (#ID) '" LIMIT 1';
		Inline: $IV_SearchUsers, -SQL=#SQLGetUserName;
			If: (Found_Count) != 0;
				#vUserNameLabel = (Field:'User_FName') ' ' (Field:'User_LName');
			Else;
				#vUserNameLabel = 'Nobody';
			/If;
		/Inline;

		#Result = #vUserNameLabel;

		Return: #Result;

	/Define_Tag;

/If;

// Tagname: 	GetVersionName
// Description:	Gets the Version Name when passed a Version_ID
// Author:		Eric Landmann
// Date:		8/7/2006
// Usage: 		GetVersionName: -ID='2'
// Notes: 		Expected output from tag: "Beta"
If: !(Lasso_TagExists:'GetVersionName');

	Define_Tag: 'GetVersionName', -Required='ID';
	
		Local:'Result' = string;
		Local:'SQLGetVersionName' = string;
		Local:'vVersionNameLabel' = string;
		
		#SQLGetVersionName = 'SELECT * FROM ' $svVersionsTable ' WHERE Version_ID = "' (#ID) ' " LIMIT 1';
		Inline: $IV_SearchVersions, -SQL=#SQLGetVersionName;
			If: (Found_Count) != 0;
				#vVersionNameLabel = (Field:'Version_Name');
			Else;
				#vVersionNameLabel = 'Nothing';
			/If;
		/Inline;

		#Result = #vVersionNameLabel;

		Return: #Result;

	/Define_Tag;

/If;

// Tagname: 	GetPriorityName
// Description:	Gets the Priority Name when passed a Priority_ID
// Author:		Eric Landmann
// Date:		8/7/2006
// Usage: 		GetPriorityName: -ID='3'
// Notes: 		Expected output from tag: "3 - Medium"
If: !(Lasso_TagExists:'GetPriorityName');

	Define_Tag: 'GetPriorityName', -Required='ID';
	
		Local:'Result' = string;
		Local:'SQLGetPriorityName' = string;
		Local:'vPriorityNameLabel' = string;
		
		#SQLGetPriorityName = 'SELECT * FROM ' $svPriorityTable ' WHERE Priority_ID = "' (#ID) ' " LIMIT 1';
		Inline: $IV_SearchPriority, -SQL=#SQLGetPriorityName;
			If: (Found_Count) != 0;
				#vPriorityNameLabel = (Field:'Priority_Name');
			Else;
				#vPriorityNameLabel = 'Priority deleted';
			/If;
		/Inline;

		#Result = #vPriorityNameLabel;

		Return: #Result;

	/Define_Tag;

/If;

// Tagname: 	GetStatusName
// Description:	Gets the Status Name when passed a Status_ID
// Author:		Eric Landmann
// Date:		8/7/2006
// Usage: 		GetStatusName: -ID='3'
// Notes: 		Expected output from tag: "Assigned"
If: !(Lasso_TagExists:'GetStatusName');

	Define_Tag: 'GetStatusName', -Required='ID';
	
		Local:'Result' = string;
		Local:'SQLGetStatusName' = string;
		Local:'vStatusNameLabel' = string;
		
		#SQLGetStatusName = 'SELECT Status_ID,Status_Name FROM ' $svStatusTable ' WHERE Status_ID = "' (#ID) ' " LIMIT 1';
		Inline: $IV_SearchStatus, -SQL=#SQLGetStatusName;
			If: (Found_Count) != 0;
				#vStatusNameLabel = (Field:'Status_Name');
			Else;
				#vStatusNameLabel = 'Status deleted';
			/If;
		/Inline;

		#Result = #vStatusNameLabel;

		Return: #Result;

	/Define_Tag;

/If;

// Tagname: 	GetResolutionName
// Description:	Gets the Resolution Name when passed a Resolution_ID
// Author:		Eric Landmann
// Date:		8/7/2006
// Usage: 		GetResolutionName: -ID='10'
// Notes: 		Expected output from tag: "Feature Added"
If: !(Lasso_TagExists:'GetResolutionName');

	Define_Tag: 'GetResolutionName', -Required='ID';
	
		Local:'Result' = string;
		Local:'SQLGetResolutionName' = string;
		Local:'vResolutionNameLabel' = string;
		
		#SQLGetResolutionName = 'SELECT Resolution_ID,Resolution_Name FROM ' $svResolutionsTable ' WHERE Resolution_ID = "' (#ID) ' " LIMIT 1';
		Inline: $IV_SearchResolutions, -SQL=#SQLGetResolutionName;
			If: (Found_Count) != 0;
				#vResolutionNameLabel = (Field:'Resolution_Name');
			Else;
				#vResolutionNameLabel = 'Unresolved';
			/If;
		/Inline;

		#Result = #vResolutionNameLabel;

		Return: #Result;

	/Define_Tag;

/If;

// Tagname: 	GetSeverityName
// Description:	Gets the Severity Name when passed a Severity_ID
// Author:		Eric Landmann
// Date:		8/7/2006
// Usage: 		GetSeverityName: -ID='7'
// Notes: 		Expected output from tag: "Critical"
If: !(Lasso_TagExists:'GetSeverityName');

	Define_Tag: 'GetSeverityName', -Required='ID';
	
		Local:'Result' = string;
		Local:'SQLGetSeverityName' = string;
		Local:'vSeverityNameLabel' = string;
		
		#SQLGetSeverityName = 'SELECT Severity_ID,Severity_Name FROM ' $svSeverityTable ' WHERE Severity_ID = "' (#ID) ' " LIMIT 1';
		Inline: $IV_SearchSeverity, -SQL=#SQLGetSeverityName;
			If: (Found_Count) != 0;
				#vSeverityNameLabel = (Field:'Severity_Name');
			Else;
				#vSeverityNameLabel = 'Severity deleted';
			/If;
		/Inline;

		#Result = #vSeverityNameLabel;

		Return: #Result;

	/Define_Tag;

/If;

// Tagname: 	GetBrowserName
// Description:	Gets the Browser Name when passed a Browser_ID
// Author:		Eric Landmann
// Date:		8/15/2006
// Usage: 		GetBrowserName: -ID='7'
// Notes: 		Expected output from tag: "Critical"
If: !(Lasso_TagExists:'GetBrowserName');

	Define_Tag: 'GetBrowserName', -Required='ID';
	
		Local:'Result' = string;
		Local:'SQLGetBrowserName' = string;
		Local:'vBrowserNameLabel' = string;
		
		#SQLGetBrowserName = 'SELECT Browser_ID,Browser_Name FROM ' $svBrowsersTable ' WHERE Browser_ID = "' (#ID) ' " LIMIT 1';
		Inline: $IV_SearchBrowsers, -SQL=#SQLGetBrowserName;
			If: (Found_Count) != 0;
				#vBrowserNameLabel = (Field:'Browser_Name');
			Else;
				#vBrowserNameLabel = 'Browser deleted';
			/If;
		/Inline;

		#Result = #vBrowserNameLabel;

		Return: #Result;

	/Define_Tag;

/If;

// Tagname: 	GetOSName
// Description:	Gets the OS Name when passed a OS_ID
// Author:		Eric Landmann
// Date:		8/15/2006
// Usage: 		GetOSName: -ID='7'
// Notes: 		Expected output from tag: "Critical"
If: !(Lasso_TagExists:'GetOSName');

	Define_Tag: 'GetOSName', -Required='ID';
	
		Local:'Result' = string;
		Local:'SQLGetOSName' = string;
		Local:'vOSNameLabel' = string;
		
		#SQLGetOSName = 'SELECT OS_ID,OS_Name FROM ' $svOSTable ' WHERE OS_ID = "' (#ID) ' " LIMIT 1';
		Inline: $IV_SearchOS, -SQL=#SQLGetOSName;
			If: (Found_Count) != 0;
				#vOSNameLabel = (Field:'OS_Name');
			Else;
				#vOSNameLabel = 'OS deleted';
			/If;
		/Inline;

		#Result = #vOSNameLabel;

		Return: #Result;

	/Define_Tag;

/If;

// Tagname: 	GetComment
// Description:	Gets the Comment when passed an ID of the Comment record
// Author:		Eric Landmann
// Date:		8/7/2006
// Usage: 		GetComment: -ID='186'
// Notes: 		Expected output from tag: "Some sort of comment."
If: !(Lasso_TagExists:'GetComment');

	Define_Tag: 'GetComment', -Required='ID';
	
		Local:'Result' = string;
		Local:'SQLGetComment' = string;
		Local:'vCommentText' = string;
		
		#SQLGetComment = 'SELECT * FROM ' $svCommentsTable '  WHERE Comment_ID = "' (#ID) '" LIMIT 1';
		Inline: $IV_SearchComments, -SQL=#SQLGetComment;
			If: (Found_Count) != 0;
				#vCommentText = (Field:'Comment_Text',-EncodeBreak);
			Else;
				#vCommentText = 'Comment deleted.';
			/If;
		/Inline;

		#Result = #vCommentText;

		Return: #Result;

	/Define_Tag;

/If;

// Tagname: 	GetAttachmentName
// Description:	Gets the Attachment Name when passed an ID of the Attachment record
// Author:		Eric Landmann
// Date:		8/7/2006
// Usage: 		GetAttachmentName: -ID='7'
// Notes: 		Expected output from tag: "UploadNoAttachment_676.jpg"
If: !(Lasso_TagExists:'GetAttachmentName');

	Define_Tag: 'GetAttachmentName', -Required='ID';
	
		Local:'Result' = string;
		Local:'SQLGetAttachmentName' = string;
		Local:'vAttachmentNameLabel' = string;
		
		#SQLGetAttachmentName = 'SELECT Attach_Filename FROM ' $svAttachmentsTable ' WHERE ID = "' (#ID) ' " LIMIT 1';
		Inline: $IV_SearchAttachments, -SQL=#SQLGetAttachmentName;
			If: (Found_Count) != 0;
				#vAttachmentNameLabel = (Field:'Attach_Filename');
			Else;
				#vAttachmentNameLabel = 'Attachment deleted';
			/If;
		/Inline;

		#Result = #vAttachmentNameLabel;

		Return: #Result;

	/Define_Tag;

/If;

// Tagname: 	CheckIfAssigned
// Description:	Checks to see if a developer has been assigned to a bug when passed a Bug ID
// 				Returns the User ID of the developer who is assigned
// Author:		Eric Landmann
// Date:		8/7/2006
// Usage: 		CheckIfAssigned: -BugID='92'
// Notes: 		Expected output from tag: "2F0a33X"
If: !(Lasso_TagExists:'CheckIfAssigned');

	Define_Tag: 'CheckIfAssigned', -Required='BugID';
	
		Local:'Result' = string;
		Local:'SQLCheckIfAssigned' = string;
		Local:'vAssignedUserID' = string;
		
		#SQLCheckIfAssigned = 'SELECT Assigned_To FROM ' $svBugsTable ' WHERE Bug_ID = "' (#BugID) '" LIMIT 1';
		Inline: $IV_SearchBugs, -SQL=#SQLCheckIfAssigned;
			If: (Found_Count) != 0;
				#vAssignedUserID = (Field:'Assigned_To');
			/If;
		/Inline;

		#Result = #vAssignedUserID;

		Return: #Result;

	/Define_Tag;

/If;


?>
